/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.recipes.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.crafting.CompactCrafting;
import dev.compactmods.crafting.api.components.IRecipeBlockComponent;
import dev.compactmods.crafting.api.components.IRecipeComponent;
import dev.compactmods.crafting.api.components.RecipeComponentType;
import dev.compactmods.crafting.recipes.components.ComponentRegistration;
import dev.compactmods.crafting.util.CodecExtensions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockComponent
implements IRecipeComponent,
IRecipeBlockComponent {
    private final Block block;
    private final Set<BlockState> validStates;
    private boolean erroredRendering = false;
    private final Map<String, Predicate<Comparable<?>>> filters;
    private final HashMap<String, List<String>> allowedValues;
    public static final Codec<BlockComponent> CODEC = RecordCodecBuilder.create(i -> i.group((App)CodecExtensions.BLOCK_ID_CODEC.fieldOf("block").forGetter(BlockComponent::getBlock), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()).optionalFieldOf("properties").forGetter(BlockComponent::getProperties)).apply((Applicative)i, BlockComponent::new));

    private Optional<Map<String, List<String>>> getProperties() {
        return Optional.of(this.allowedValues);
    }

    public BlockComponent(Block block) {
        this.block = block;
        this.filters = new HashMap();
        this.allowedValues = new HashMap();
        this.validStates = new HashSet<BlockState>();
        this.buildValidStates();
    }

    public BlockComponent(Block block, Optional<Map<String, List<String>>> propertyRequirements) {
        this(block);
        this.validStates.clear();
        StateDefinition stateContainer = this.block.m_49965_();
        propertyRequirements.ifPresent(userRequestedValues -> {
            for (Map.Entry<String, List<String>> entry : userRequestedValues.entrySet()) {
                this.validateAndAddUserFilter((StateDefinition<Block, BlockState>)stateContainer, entry);
            }
        });
        this.buildValidStates();
    }

    private void buildValidStates() {
        Set valid = this.block.m_49965_().m_61056_().stream().filter(this::matches).collect(Collectors.toSet());
        this.validStates.addAll(valid);
    }

    private void validateAndAddUserFilter(StateDefinition<Block, BlockState> stateContainer, Map.Entry<String, List<String>> userPropFilter) {
        String propertyName = userPropFilter.getKey();
        Property prop = stateContainer.m_61081_(propertyName);
        if (prop == null) {
            CompactCrafting.RECIPE_LOGGER.warn("Not a valid property: " + propertyName);
            return;
        }
        ArrayList userAllowed = new ArrayList();
        ArrayList propertyAcceptableValues = new ArrayList();
        for (String userValue : userPropFilter.getValue()) {
            prop.m_6215_(userValue).ifPresent(u -> {
                propertyAcceptableValues.add(userValue);
                userAllowed.add(u);
            });
        }
        this.allowedValues.put(propertyName, propertyAcceptableValues);
        this.filters.put(propertyName, userAllowed::contains);
    }

    @Override
    public boolean matches(BlockState state) {
        if (!state.m_60734_().equals(this.block)) {
            return false;
        }
        for (Property prop : state.m_61147_()) {
            String name = prop.m_61708_();
            if (!this.filters.containsKey(name)) continue;
            Comparable val = state.m_61143_(prop);
            boolean matches = this.filters.get(name).test(val);
            if (matches) continue;
            return false;
        }
        return true;
    }

    @Override
    public RecipeComponentType<?> getType() {
        return (RecipeComponentType)ComponentRegistration.BLOCK_COMPONENT.get();
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockState getRenderState() {
        return this.block.m_49966_();
    }

    @Override
    public boolean didErrorRendering() {
        return this.erroredRendering;
    }

    @Override
    public void markRenderingErrored() {
        this.erroredRendering = true;
    }

    public boolean hasFilter(String property) {
        return this.filters.containsKey(property);
    }

    public Optional<BlockState> getFirstMatch() {
        return this.validStates.stream().findFirst();
    }

    public String toString() {
        return String.format("Block {%s}", this.block.getRegistryName());
    }
}

